<?php

/**
 * This is the model class for table "author".
 */
class Author extends BaseActiveRecord
{
	/**
	 * The followings are the available columns in table 'author':
	 * @var integer $id
	 * @var string $name
	 * @var integer $uid
	 * @var string $createdate
	 * @var string $updatedate
	 * @var integer $status
	 * @var string $remark
	 */

	/**
	 * Returns the static model of the specified AR class.
	 * @return Author the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'ig_author';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('name, createdate', 'required'),
			array('uid, status', 'numerical', 'integerOnly'=>true),
			array('name', 'length', 'max'=>16),
			array('updatedate, remark', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id, name, uid, createdate, updatedate, status, remark', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'name' => 'Name',
			'uid' => 'Uid',
			'createdate' => 'Createdate',
			'updatedate' => 'Updatedate',
			'status' => 'Status',
			'remark' => 'Remark',
		);
	}
}