<?php

/**
 * This is the model class for table "bookforum".
 */
class BookForums extends BaseActiveRecord
{
	/**
	 * The followings are the available columns in table 'bookforum':
	 * @var integer $bookforumid
	 * @var integer $bookid
	 * @var string $forumname
	 * @var integer $comments
	 * @var integer $level
	 * @var integer $digests
	 * @var string $income
	 * @var integer $mcount
	 * @var integer $click
	 * @var integer $highest
	 * @var integer $posts
	 * @var integer $todayposts
	 * @var integer $digest
	 * @var string $createdate
	 * @var integer $monthmcount
	 * @var integer $monthdigests
	 * @var integer $monthposts
	 * @var integer $chat
	 * @var integer $advance
	 * @var integer $monthadvance
	 */

	/**
	 * Returns the static model of the specified AR class.
	 * @return BookForums the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'ig_bookforum';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('bookid, forumname, mcount, createdate', 'required'),
			array('bookid, comments, level, digests, mcount, click, highest, posts, todayposts, digest, monthmcount, monthdigests, monthposts, chat, advance, monthadvance', 'numerical', 'integerOnly'=>true),
			array('forumname', 'length', 'max'=>255),
			array('income', 'length', 'max'=>20),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'bookforumid' => 'Bookforumid',
			'bookid' => 'Bookid',
			'forumname' => 'Forumname',
			'comments' => 'Comments',
			'level' => 'Level',
			'digests' => 'Digests',
			'income' => 'Income',
			'mcount' => 'Mcount',
			'click' => 'Click',
			'highest' => 'Highest',
			'posts' => 'Posts',
			'todayposts' => 'Todayposts',
			'digest' => 'Digest',
			'createdate' => 'Createdate',
			'monthmcount' => 'Monthmcount',
			'monthdigests' => 'Monthdigests',
			'monthposts' => 'Monthposts',
			'chat' => 'Chat',
			'advance' => 'Advance',
			'monthadvance' => 'Monthadvance',
		);
	}
}