<?php

/**
 * This is the model class for table "bookgaglog".
 */
class BookGagLog extends BaseActiveRecord
{
	/**
	 * The followings are the available columns in table 'bookgaglog':
	 * @var integer $id
	 * @var integer $uid
	 * @var string $username
	 * @var integer $operate_uid
	 * @var string $operate_username
	 * @var integer $bookid
	 * @var integer $day
	 * @var string $remark
	 * @var string $createdate
	 */

	/**
	 * Returns the static model of the specified AR class.
	 * @return BookGagLog the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'ig_bookgaglog';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('uid, username, operate_uid, operate_username, remark, createdate', 'required'),
			array('uid, operate_uid, bookid, day', 'numerical', 'integerOnly'=>true),
			array('username, operate_username', 'length', 'max'=>20),
			array('remark', 'length', 'max'=>200),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id, uid, username, operate_uid, operate_username, bookid, day, remark, createdate', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		    'book' => array(self::BELONGS_TO, 'Books', 'bookid'),
		);
	}
	
	/**
     * 可用行为列表
     * @return array
     */
    public function behaviors()
    {
        return array(
			// 自动填充创建时间
			'CreateAt' => array(
				'class' => 'application.models.behaviors.CreateAtBehavior',
			),
        );
    }
    
	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'uid' => 'UID',
			'username' => '用户名',
			'operate_uid' => '操作者UID',
			'operate_username' => '操作者名',
			'bookid' => '小说ID',
			'day' => '禁言天数',
			'remark' => '说明',
			'createdate' => '创建时间',
		);
	}
}