<?php

/**
 * This is the model class for table "ig_bookmanage".
 */
class BookManage extends BaseActiveRecord
{
	/**
	 * The followings are the available columns in table 'ig_bookmanage':
	 * @var integer $bookmanageid
	 * @var integer $bookid
	 * @var integer $uid
	 * @var string $username
	 * @var integer $status
	 * @var integer $digest
	 * @var string $createdate
	 * @var string $updatedate
	 * @var string $remarks
	 * @var string $canceltime
	 */

    public static $_status = array(0=>'待审核',1=>'正常',2=>'撤职');
	/**
	 * Returns the static model of the specified AR class.
	 * @return BookManage the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'ig_bookmanage';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('bookid, uid, username', 'required'),
			array('bookid, uid, status, digest', 'numerical', 'integerOnly'=>true),
			array('username', 'length', 'max'=>20),
			array('remarks', 'length', 'max'=>200),
			array('canceltime', 'safe'),
            array('createdate', 'default', 'value'=>CDATETIME,'setOnEmpty'=>false,'on'=>'insert'),
            array('updatedate', 'default', 'value'=>CDATETIME,'setOnEmpty'=>false,'on'=>'update'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('bookmanageid, bookid, uid, username, status, digest, createdate, updatedate, remarks, canceltime', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'bookmanageid' => 'ID',
			'bookid' => '小说ID',
			'uid' => 'UID',
			'username' => '用户名',
			'status' => '状态',
			'digest' => '加精数',
			'createdate' => '创建日期',
			'updatedate' => '修改日期',
			'remarks' => '备注',
			'canceltime' => '撤职日期',
		);
	}

    public function afterSave()
    {
        Front::updateBookManage($this->bookid);

        return true;
    }

    public function getStatus()
    {
        echo $this->status == 2 ? '<font color="red">已撤职</font>' : (1 == $this->status ? '正常' : '待审核');
    }
}