<?php

/**
 * This is the model class for table "bookpaylog".
 */
class BookPayLogs extends BaseActiveRecord
{
	/**
	 * The followings are the available columns in table 'bookpaylog':
	 * @var integer $id
	 * @var string $bookname
	 * @var integer $bid
	 * @var integer $credits
	 * @var integer $price
	 * @var integer $size
	 * @var integer $uid
	 * @var string $username
	 * @var string $createdate
	 * @var string $edate
	 * @var string $sdate
	 * @var string $date
	 */

	/**
	 * Returns the static model of the specified AR class.
	 * @return BookPayLog the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'ig_bookpaylog';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('bookname, bid, username, createdate, edate, sdate, date', 'required'),
			array('bid, credits, price, size, uid', 'numerical', 'integerOnly'=>true),
			array('bookname', 'length', 'max'=>200),
			array('username', 'length', 'max'=>20),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id, bookname, bid, credits, price, size, uid, username, createdate, edate, sdate, date', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'bookname' => '书名',
			'bid' => 'BID',
			'credits' => setting('creditname'),
			'price' => '单价',
			'size' => '字数',
			'uid' => 'UID',
			'username' => '用户名',
			'createdate' => '创建时间',
			'edate' => '起始日期',
			'sdate' => '结束日期',
			'date' => '生成日期',
		);
	}
}