<?php

/**
 * 高级贴投诉内容
 */
class BookPostComplaint extends BaseActiveRecord
{
	/**
	 * The followings are the available columns in table 'bookpostcomplaints':
	 * @var integer $id
	 * @var integer $bookid
	 * @var integer $postid
	 * @var string $subject
	 * @var integer $authorid
	 * @var string $author
	 * @var integer $uid
	 * @var string $username
	 * @var string $content
	 * @var integer $createdate
	 */

	/**
	 * Returns the static model of the specified AR class.
	 * @return BookPostComplaint the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'ig_bookpostcomplaints';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('bookid, postid, subject, authorid, author, uid, username, content, createdate', 'required'),
			array('bookid, postid, authorid, uid, createdate', 'numerical', 'integerOnly'=>true),
			array('subject', 'length', 'max'=>200),
            array('iaward','safe'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
            'book' => array(self::BELONGS_TO, 'Books', 'bookid'),
            'reply' => array(self::BELONGS_TO, 'BookPostReplys', '', 'on'=>'t.postid=reply.postid'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'bookid' => '小说ID',
			'postid' => '贴ID',
			'subject' => '主题',
			'authorid' => '发帖人ID',
			'author' => '发帖人用户名',
			'uid' => '投诉人UID',
			'username' => '投诉人用户名',
			'content' => '内容',
			'createdate' => '创建时间',
		);
	}
}