<?php

/**
 * This is the model class for table "bookpostreply".
 */
class BookPostReplys extends BaseActiveRecord
{
	/**
	 * The followings are the available columns in table 'bookpostreply':
	 * @var double $id
	 * @var integer $postid
	 * @var integer $bookid
	 * @var integer $uid
	 * @var string $username
	 * @var string $subject
	 * @var string $content
	 * @var integer $createdate
	 * @var integer $lastreply
	 * @var integer $isfirst
	 * @var integer $price
	 * @var string $buyer
	 * @var string $loginip
	 * @var integer $replycount
	 * @var integer $viewcount
	 * @var string $bad
	 * @var string $good
	 * @var string $complaints
	 */

	/**
	 * Returns the static model of the specified AR class.
	 * @return CActiveRecord the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'ig_bookpostreply';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('bookid, uid, username, content, createdate', 'required'),
			array('postid, bookid, uid, createdate, lastreply, isfirst, price, replycount, viewcount', 'numerical', 'integerOnly'=>true),
			array('subject', 'length', 'max'=>200),
			array('loginip', 'length', 'max'=>20),
			array('buyer, bad, good, complaints', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id, postid, bookid, uid, username, subject, content, createdate, lastreply, isfirst, price, buyer, loginip, replycount, viewcount, bad, good, complaints,ispunish', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
            'book' => array(self::BELONGS_TO, 'Books','bookid'),
            'complaints' => array(self::HAS_MANY, 'BookPostComplaint', 'postid'),
		);
	}

    public function afterDelete()
    {
        parent::afterDelete();
        
        if ($this->isfirst)
        {
            // 删除高级贴的同时将书会里的贴一起删了 
            $post = BookPosts::model()->find($this->postid);
            if (!empty($post))
            {
                $post->delete();
                Front::updateAdvancePost($this->bookid);
            }

            // 删掉回帖
            $this->deleteAll("isfirst = 0 AND postid={$this->postid}");
        }
        else
        {
            // 回帖数减1
            $this->updateCounters(array('relycount'=>-1),'postid='.$this->postid);
        }

        return true;
    }

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'postid' => 'PostID',
			'bookid' => 'BookID',
			'uid' => 'UID',
			'username' => '用户名',
			'subject' => '标题',
			'content' => '内容',
			'createdate' => '创建时间',
			'lastreply' => '最后回复',
			'isfirst' => '主题贴',
			'price' => '售价',
			'buyer' => '购买者',
			'loginip' => 'IP',
			'replycount' => '回复数',
			'viewcount' => '显示',
			'bad' => '差评',
			'good' => '好评',
			'complaints' => '投诉',
		);
	}
}