<?php

/**
 * This is the model class for table "bookposts".
 */
class BookPosts extends BaseActiveRecord
{
	/**
	 * The followings are the available columns in table 'bookposts':
	 * @var integer $bookpostsid
	 * @var integer $uid
	 * @var string $username
	 * @var integer $bookid
	 * @var string $message
	 * @var string $loginip
	 * @var string $createdate
	 * @var string $date
	 * @var integer $digest
	 * @var string $remarks
	 * @var integer $deleted
	 * @var integer $applydigest
	 * @var integer $isadvance
	 * @var integer $lastpost
	 */

	/**
	 * Returns the static model of the specified AR class.
	 * @return Bookposts the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'ig_bookposts';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('uid, username, bookid, message, loginip, createdate, lastpost', 'required'),
			array('uid, bookid, digest, deleted, applydigest, isadvance, lastpost', 'numerical', 'integerOnly'=>true),
			array('username, loginip', 'length', 'max'=>20),
			array('remarks', 'length', 'max'=>255),
			array('date', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('bookpostsid, uid, username, bookid, message, loginip, createdate, date, digest, remarks, deleted, applydigest, isadvance, lastpost', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

    public function afterDelete()
    {
        parent::afterDelete();

        // 日发帖 月发帖 总贴统统减1，如果是精华贴则日精华 月精华 总精华也要减1
        $counters['posts'] = -1;
        $counters['todayposts'] = -1;
        $counters['monthposts'] = -1;
        if ($this->digest)
        {
            $counters['digest'] = -1;
            $counters['monthdigests'] = -1;
        }
        if ($this->isadvance)
        {
            $counters['advance'] = -1;
            $counters['monthadvance'] = -1;
        }
        BookForums::model()->updateCounters($counters,'bookid='.$this->bookid);
        
        // 刷新书会缓存
        Front::updateBookForum($this->bookid);
        
        return true;
    }

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'bookpostsid' => 'Bookpostsid',
			'uid' => 'Uid',
			'username' => 'Username',
			'bookid' => 'Bookid',
			'message' => 'Message',
			'loginip' => 'Loginip',
			'createdate' => 'Createdate',
			'date' => 'Date',
			'digest' => 'Digest',
			'remarks' => 'Remarks',
			'deleted' => 'Deleted',
			'applydigest' => 'Applydigest',
			'isadvance' => 'Isadvance',
			'lastpost' => 'Lastpost',
		);
	}
}