<?php

/**
 * 投票选择列表
 */
class BookVoteOption extends BaseActiveRecord
{
	/**
	 * The followings are the available columns in table 'bookvoteoption':
	 * @var integer $id
	 * @var integer $voteid
	 * @var integer $votes
	 * @var integer $displayorder
	 * @var string $option
	 * @var string $voterids
	 */

	/**
	 * Returns the static model of the specified AR class.
	 * @return BookVoteOption the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'ig_bookvoteoption';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('voteid, displayorder, option', 'required'),
			array('voteid, votes, displayorder', 'numerical', 'integerOnly'=>true),
			array('option', 'length', 'max'=>200),
			array('voterids', 'safe'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'voteid' => '投票ID',
			'votes' => '得票数',
			'displayorder' => '排序',
			'option' => '选项',
			'voterids' => '投票人ID',
		);
	}
}