<?php

/**
 * 书管投票列表
 */
class BookVotes extends BaseActiveRecord
{
	/**
	 * The followings are the available columns in table 'bookvote':
	 * @var integer $id
	 * @var string $subject
	 * @var integer $bookid
	 * @var integer $uid
	 * @var string $username
	 * @var integer $expire
	 * @var integer $issuper
	 * @var integer $isbook
	 * @var integer $maxchoices
	 * @var integer $createdate
	 * @var string $voterids
	 * @var integer $award
	 * @var string $description
	 */

	/**
	 * Returns the static model of the specified AR class.
	 * @return BookVote the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'ig_bookvote';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('subject, uid, username, expire, createdate', 'required'),
			array('bookid, uid, expire, issuper, isbook, maxchoices, createdate, award', 'numerical', 'integerOnly'=>true),
			array('subject', 'length', 'max'=>100),
			array('username', 'length', 'max'=>16),
			array('description', 'length', 'max'=>255),
			array('voterids', 'safe'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'subject' => '主题',
			'bookid' => '小说ID',
			'uid' => 'UID',
			'username' => '用户名',
			'expire' => '过期时间',
			'issuper' => '是否为超管',
			'isbook' => '是否为书管',
			'maxchoices' => '最大选项',
			'createdate' => '创建时间',
			'voterids' => '投票用户ID',
			'award' => '奖励',
			'description' => '说明',
		);
	}
}