<?php
/* 
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 * Description of Books
 *
 * @author yzxh24
 */
class Books extends BaseActiveRecord
{
    /**
     * 写作状态
     */
    public static $_status = array(0=>'连载',1=>'完成');
    
    /**
     * 是否为VIP作品
     */
    public static $_isvip = array(0 => '否', 1 => '是');

    /**
     * 显示状态
     */
    public static $_view = array(0=>'隐藏',1=>'显示');

    /**
     * 采集状态
     */
    public static $_stopcollect = array(0=>'停止',1=>'正常');

    /**
     * 小说性质
     */
    public static $_nature = array(1=>'公众作品',2=>'VIP作品');

    /**
     * 授权性质
     */
    public static $_type = array(1=>'他站转载',2=>'本站原创');

    /**
     * 推荐状态
     */
    public static $_command = array(0=>'否',1=>'是');

    /**
     * 封面图片对象
     */
    public $imageObj = null;
    
    /**
     * @return Books
     */
    public static function model($className = __CLASS__)
    {
        return parent::model($className);
    }

    public function tableName()
    {
        return 'ig_book';
    }

    public function rules()
    {
        return array(
            array('bookname,author,aliasname,bookinfo,status,view,type,nature,commend,typeid','safe'),
        );
    }
    
    public function relations()
	{
		return array(
			'chapter' => array(self::HAS_MANY, 'Chapters', 'bookid'),
			'types' => array(self::BELONGS_TO, 'Type', 'typeid', 'alias'=>'type'),
            'authors' => array(self::BELONGS_TO, 'Author', 'authorid', 'alias'=>'authors'),
		);
	}

    public function scopes()
    {
        return array(
			'published' => array(
				'condition' => 't.view=1',
			),
		);
    }

    public function attributeLabels()
    {
        return array(
            'bookid' => 'ID',
            'bookname' => '书名',
            'aliasname' => '别名',
            'bookinfo' => '简介',
            'typeid' => '分类ID',
            'author' => '作者',
            'authorid' => '作者ID',
            'createdate' => '创建时间',
            'click' => '总点击',
            'd_click' => '日点击',
            'w_click' => '周点击',
            'm_cilci' => '月点击',
            'status' => '写作状态',
            'size' => '字数',
            'flower' => '鲜花',
            'egg' => '板砖',
            'isvip' => 'VIP',
            'commend' => '推荐',
            'view' => '显示状态',
            'chapters' => '章节总数',
            'lastchapterid' => '最新章节ID',
            'lastchaptername' => '最新章节',
            'updatedate' => '更新时间',
            'nature' => '授权性质',
            'type' => '类型',
            'image' => '封面',
        );
    }

    public function afterSave()
    {
        parent::afterSave();

        // 处理封面的上传
        if (!is_null($this->imageObj) && $this->imageObj instanceof CUploadedFile)
        {
            $path = $this->getCoverBasePath();
            $fileName = $this->bookid . '.' . $this->imageObj->getExtensionName();
            $file = $path . $fileName;
            $this->imageObj->saveAs($file);

            Books::model()->updateByPk($this->bookid, array('image'=>$fileName));
            $this->_updateCache($this->bookid);
        }

        // 更新缓存
        Front::updateBookInfo($this->bookid);

        return true;
    }
    
    public function afterDelete()
    {
        $path = $this->getCoverBasePath();
        IFileHelper::deleteDir($path);
        
        return true;
    }

    /**
     * 获取封面存储路径
     * @param int $bookId
     * @return string
     */
    public function getCoverBasePath()
    {
        return Front::getCoverPath($this->bookid);
    }
    
    public function getBaseFolder()
    {
        return Front::getMd($this->bookid);
    }
    
    /**
     * 获取书籍的封面地址
     * @param int $bookId
     * @return string
     */
    public function getCoverUrl()
	{
        $bookCache = $this->getBookByCache($this->bookid);
        $coverUrl = Yii::app()->params['imageUrl'] . 'cover.gif';
        if (!empty($bookCache->image))
        {
            $coverFile = $this->getCoverBasePath($this->bookid) . $bookCache->image;
            if (is_file($coverFile) && filesize($coverFile) > 308)
            {
                $coverUrl = Front::getCoverBaseUrl() . $this->getBaseFolder() . '/' . $bookCache->image;
            }
        }

		return $coverUrl;
	}

    /**
     * 从缓存中获取一本小说的信息
     * @param int $bookId
     * @return Books
     */
    public function getBookByCache($bookId)
	{
		$key = md5('MyBookCache' . $bookId);
		$book = Yii::app()->cache->get($key);
		if (false === $book)
		{
			$book = $this->_updateCache($bookId);
		}

		return $book;
	}

    /**
     * 刷新书籍缓存
     * @param int $bookId
     * @return Books
     */
    public function _updateCache($bookId)
    {
        $key = md5('MyBookCache' . $bookId);
        $book = $this->with('types')->find(array('select'=>'*','condition'=>"bookid='$bookId'"));
        Yii::app()->cache->set($key, $book, 300);

        return $book;
    }

    public function getStatus($status)
    {
        return $status ? '<font color=red>'.self::$_status[$status].'</font>' : self::$_status[$status];
    }

    public function getView($view)
    {
        return $view ? self::$_view[$view] : '<font color=red>'.self::$_view[$view].'</font>';
    }

    public function getType($type)
    {
        echo $type == 1 ? self::$_type[$type] : '<font color=red>'.self::$_type[$type].'</font>';
    }

    public function getSize($size)
    {
        echo round($size / 10000,2) . '万字';
    }

    public function isVip($isVip)
    {
        echo $isVip ? '<font color="red">是</font>' : '否';
    }
}