<?php

/**
 * This is the model class for table "ig_demand".
 */
class Demands extends BaseActiveRecord
{
	/**
	 * The followings are the available columns in table 'ig_demand':
	 * @var string $id
	 * @var integer $uid
	 * @var string $username
	 * @var string $bookname
	 * @var string $author
	 * @var integer $createdate
	 * @var integer $status
	 */

    public static $status = array(0=>'未处理',1=>'已上架',2=>'已取消');
    
	/**
	 * Returns the static model of the specified AR class.
	 * @return Demands the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'ig_demand';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('uid, username, bookname, createdate', 'required'),
			array('uid, createdate, status', 'numerical', 'integerOnly'=>true),
			array('username', 'length', 'max'=>20),
			array('bookname', 'length', 'max'=>150),
			array('author', 'length', 'max'=>50),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id, uid, username, bookname, author, createdate, status', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'uid' => 'UID',
			'username' => '用户名',
			'bookname' => '书名',
			'author' => '作者',
			'createdate' => '创建时间',
			'status' => '状态',
		);
	}
}