<?php

/**
 * This is the model class for table "favorites".
 */
class Favorite extends BaseActiveRecord
{
	/**
	 * The followings are the available columns in table 'favorites':
	 * @var integer $favoritesid
	 * @var integer $memberid
	 * @var integer $tid
	 * @var integer $bid
	 * @var integer $cid
	 * @var integer $sp
	 * @var integer $tp
	 * @var integer $page
	 * @var string $createdate
	 * @var integer $sort
	 */

	/**
	 * Returns the static model of the specified AR class.
	 * @return Favorite the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'ig_bookfavorites';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('memberid, tid, bid, createdate', 'required'),
			array('memberid, tid, bid, cid, sp, tp, page, sort', 'numerical', 'integerOnly'=>true),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('favoritesid, memberid, tid, bid, cid, sp, tp, page, createdate, sort', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		    'books' => array(self::BELONGS_TO, 'Books', 'bid'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'favoritesid' => 'Favoritesid',
			'memberid' => 'Memberid',
			'tid' => 'Tid',
			'bid' => 'Bid',
			'cid' => 'Cid',
			'sp' => 'Sp',
			'tp' => 'Tp',
			'page' => 'Page',
			'createdate' => 'Createdate',
			'sort' => 'Sort',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('favoritesid',$this->favoritesid);

		$criteria->compare('memberid',$this->memberid);

		$criteria->compare('tid',$this->tid);

		$criteria->compare('bid',$this->bid);

		$criteria->compare('cid',$this->cid);

		$criteria->compare('sp',$this->sp);

		$criteria->compare('tp',$this->tp);

		$criteria->compare('page',$this->page);

		$criteria->compare('createdate',$this->createdate,true);

		$criteria->compare('sort',$this->sort);

		return new CActiveDataProvider(get_class($this), array(
			'criteria'=>$criteria,
		));
	}
}