<?php

/**
 * This is the model class for table "ig_fluxsum".
 */
class FluxSum extends BaseActiveRecord
{
	/**
	 * The followings are the available columns in table 'ig_fluxsum':
	 * @var string $date
	 * @var string $year
	 * @var string $month
	 * @var integer $pv
	 * @var integer $valid_pv
	 * @var integer $u_pv
	 * @var integer $u_valid_pv
	 * @var integer $register
	 * @var integer $verify
	 * @var integer $login
	 * @var integer $threads
	 * @var integer $posts
	 * @var integer $bookposts
	 */

	/**
	 * Returns the static model of the specified AR class.
	 * @return FluxSum the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'ig_fluxsum';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('date, year, month, u_valid_pv', 'required'),
			array('pv, valid_pv, u_pv, u_valid_pv, register, verify, login, threads, posts, bookposts', 'numerical', 'integerOnly'=>true),
			array('year', 'length', 'max'=>4),
			array('month', 'length', 'max'=>2),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('date, year, month, pv, valid_pv, u_pv, u_valid_pv, uv, valid_uv, spider, register, verify, login, threads, posts, bookposts', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'date' => '日期',
			'year' => '年',
			'month' => '月',
			'pv' => '总PV',
			'valid_pv' => '手机PV',
			'u_pv' => '会员PV',
			'u_valid_pv' => '手机会员PV',
		    'uv' => 'UV',
		    'valid_uv' => '手机UV',
		    'spider' => '搜索引擎',
			'register' => '注册',
			'verify' => '通过验证',
			'login' => '登陆',
			'threads' => '社区主题',
			'posts' => '社区回复',
			'bookposts' => '书会发言',
            'wap' => 'WAP',
            'tg' => '3G',
            'web' => 'WEB',
            'feed' => 'Feed',
		);
	}

    public static function dataSum(CDbCriteria $criteria)
	{
	    $c = clone $criteria;
	    $c->select = 'SUM(pv) AS pv, SUM(uv) AS uv, SUM(register) AS register, SUM(verify) AS verify, SUM(valid_uv) AS valid_uv, SUM(u_valid_pv) AS u_valid_pv';
	    $c->with = '';
	    return FluxSum::model()->find($c);
	}
}