<?php

/**
 * 社区版块
 */
class Forum extends BaseActiveRecord
{
	/**
	 * The followings are the available columns in table 'ig_bbs':
	 * @var integer $fid
	 * @var integer $fup
	 * @var integer $ifsub
	 * @var integer $childid
	 * @var string $type
	 * @var string $logo
	 * @var string $name
	 * @var string $description
	 * @var string $keywords
	 * @var integer $vieworder
	 * @var string $forumadmin
	 * @var string $fupadmin
	 * @var integer $allowhide
	 * @var string $allowvisit
	 * @var string $allowread
	 * @var string $allowpost
	 * @var string $allowrp
	 * @var string $allowdownload
	 * @var string $allowupload
	 * @var integer $ispostcheck
	 */
    
    private $_forumSetDb = array(
        'lock' => 1,
        'cutnums' => 20,
        'threadnum' => 20,
        'readnum' => 10,
        'viewpic' => 0,
        'threadexpire' => 0,
        'topictype' => 0,
        'threadlen' => 30,
        'replylen' => 8,
        'subjectlen' => 8,
        'ratingmax' => 20,
    );
	/**
	 * Returns the static model of the specified AR class.
	 * @return Forum the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'ig_forums';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('type, name', 'required'),
			array('fup, ifsub, childid, vieworder, allowhide, ispostcheck', 'numerical', 'integerOnly'=>true),
			array('type', 'length', 'max'=>8),
			array('logo, name', 'length', 'max'=>100),
			array('description, keywords, forumadmin, fupadmin', 'length', 'max'=>255),
			array('allowvisit, allowread, allowpost, allowrp, allowdownload, allowupload', 'length', 'max'=>255),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('fid, fup, ifsub, childid, type, logo, name, description, keywords, vieworder, forumadmin, fupadmin, allowhide, allowvisit, allowread, allowpost, allowrp, allowdownload, allowupload, ispostcheck, password, forumset, f_check', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}
	
	public function behaviors()
	{
	    return array(
	        'cache' => array(
	        	'class' => 'application.models.behaviors.Forums.CacheBehavior'
	        ),
	        'child' => array(
	            'class' => 'application.models.behaviors.Forums.ChildidBehavior'
	        ),
	    );
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'fid' => 'Fid',
			'fup' => 'Fup',
			'ifsub' => 'Ifsub',
			'childid' => 'Childid',
			'type' => 'Type',
			'logo' => 'Logo',
			'name' => 'Name',
			'description' => 'Description',
			'keywords' => 'Keywords',
			'vieworder' => 'Vieworder',
			'forumadmin' => 'Forumadmin',
			'fupadmin' => 'Fupadmin',
			'allowhide' => 'Allowhide',
			'allowvisit' => 'Allowvisit',
			'allowread' => 'Allowread',
			'allowpost' => 'Allowpost',
			'allowrp' => 'Allowrp',
			'allowdownload' => 'Allowdownload',
			'allowupload' => 'Allowupload',
			'ispostcheck' => 'Ispostcheck',
		);
	}
	
	public function beforeSave()
	{
	    parent::beforeSave();
	    
	    if ($this->isNewRecord)
	    {
	        $this->forumset = serialize($this->_forumSetDb);
	    }
	    
	    return true;
	}
    
	public function createCache($array)
	{
	    $file = $this->getCacheFile();
	    file_put_contents($file, "<?php\nreturn ".var_export($array,true).';');
	}
	
	public function getCacheFile()
	{
	    return ROOT_PATH . 'cache/bbs/forums/forum_'.$this->fid.'.php';
	}
	
	/**
	 * 整理Forum对象组
	 * @param array $forums
	 * @return array
	 */
	public static function getForumList()
	{
	    $criteria = new CDbCriteria();
        $criteria->select = 'fid,fup,type,name,vieworder,forumadmin';
        $criteria->order = 'vieworder DESC';
        $forums = Forum::model()->findAll($criteria);
        
	    $threaddb = array('catedb'=>'','forumdb'=>'','subdb1'=>'','subdb2'=>'','forum_L'=>'');
	    if (empty($forums))
	    {
	        return $threaddb;
	    }
	    
	    foreach ($forums as $forum)
        {
            $forum->name = str_replace('"','&quot;',(strip_tags($forum->name)));
    		$forum->forumadmin = trim($forum->forumadmin, ',');
    		if ($forum->type == 'category')
    		{
    			$catedb[$forum->fid] = $forum;
    		}
    		elseif ($forum->type == 'forum')
    		{
    			$forumdb[$forum->fid] = $forum;
    		}
    		elseif ($forum->type == 'sub')
    		{
    			$subdb1[$forum->fid] = $forum;
    		}
    		else
    		{
    			$subdb2[$forum->fid] = $forum;
    		}
        }
        
	    $threaddb = array();
    	foreach ($catedb as $cate)
    	{
    		$threaddb[$cate->fid] = array();
    		if (!empty($forumdb))
    		{
        		foreach ($forumdb as $key2 => $forumss)
        		{
        			if ($forumss->fup == $cate->fid)
        			{
        				$threaddb[$cate->fid][] = $forumss;
        				unset($forumdb[$key2]);
        				if (!empty($subdb1))
        				{
            				foreach ($subdb1 as $key3 => $sub1)
            				{
            					if ($sub1->fup == $forumss->fid)
            					{
            						$threaddb[$cate->fid][] = $sub1;
            						unset($subdb1[$key3]);
            						if (!empty($subdb2))
            						{
                						foreach ($subdb2 as $key4 => $sub2)
                						{
                							if ($sub2->fup == $sub1->fid)
                							{
                								$threaddb[$cate->fid][] = $sub2;
                								unset($subdb2[$key4]);
                							}
                						}
            						}
            					}
            				}
        				}
        			}
        		}
    		}
    	}
        
	    // $forum_L表示存在异常的版块，即父ID之类的出错
        $forum_L = array();
    	if ($forumdb)
    	{
    		foreach ($forumdb as $value)
    		{
    			$forum_L[] = $value;
    		}
    	}
    	if ($subdb1)
    	{
    		foreach ($subdb1 as $value)
    		{
    			$forum_L[] = $value;
    		}
    	}
    	if ($subdb2)
    	{
    		foreach ($subdb2 as $value)
    		{
    			$forum_L[] = $value;
    		}
    	}
    	
    	return array('catedb'=>$catedb,'threaddb'=>$threaddb,'subdb1'=>$subdb1,'subdb2'=>$subdb2,'forum_L'=>$forum_L);
	}
}