<?php
/**
 * Yii RBAC权限关系表,主要用于角色,任务,行动的关系
 * 三者关系如下:
 * 一个角色可以包含另外一个或者几个角色.
 * 一个角色可以包含另外一个或者几个任务.
 * 一个角色可以包含另外一个或者几个行动.
 * 一个任务可以包含另外一个或者几个任务.
 * 一个任务可以包含另外一个或者几个行动.
 * 一个行动只能被角色或者任务包含,行动不可以包含其它,也不可再分.
 *
 * @author ouyang
 *
 */
class ItemChildren extends BaseActiveRecord
{	
	public static function model($className = __CLASS__)
	{
		return parent::model($className);
	}
	
	public function tableName()
	{
		return 'ig_auth_item_child';
	}
	
	public function rules()
	{
		return array(
			array('parent,child', 'safe')
		);
	}
	
	public function relations()
	{
		return array(
            'authparent'=>array(self::BELONGS_TO, 'AuthItem', 'parent', 'alias' => 'authparent'),
            'authchild'=>array(self::BELONGS_TO, 'AuthItem', 'child', 'alias' => 'authchild'),
        );
	}
}