<?php
/**
 * 后台管理人员
 * @author yzxh24
 */
class Manager extends BaseActiveRecord
{
	/**
	 * 'manager'表 字段定义：
	 * @var integer $id ID
	 * @var string $username 用户名
	 * @var string $password 密码
	 * @var string $create_datetime 注册时间
	 * @var string $update_datetime 最后登录时间
	 * @var string $login_ip 最后登录IP
     * @var int $deleted 是否已删除
     * @var int $status 帐号状态 0表示禁止登录 1表示正常
	 * @var string $remak 备注
	 */
    /**
     * 改密码用
     * @var string
     */
    public $oldPassword;
    public $newPassword;
    public $newPasswordConfirm;

    /**
     * 定义帐号的状态
     * @var string
     */
    public static $status = array(0=>'禁止登录',1=>'正常');


    /**
     * 静态Manager实体，用于查询。
     * @param string $className
     * @return CActiveRecord 静态Manager实体
     */
	public static function model($className=__CLASS__)
    {
		return parent::model($className);
	}

	/**
	 * 返回表名
     * @return string
     */
	public function tableName()
    {
		return 'ig_admin';
	}

	/**
	 * 字段验证定义
     * @return array
     */
	public function rules()
    {
		return array(
			array('username, password, createdate', 'required', 'on'=>'insert'),
			array('username', 'length', 'max'=>20),
            array('username', 'unique'), // 用户名必须唯一
			array('password', 'length', 'min'=>6, 'max'=>40),
			array('login_ip', 'length', 'max'=>15),
			array('remark', 'length', 'max'=>255),
            array('newPassword, newPasswordConfirm, oldPassword', 'required', 'on'=>'password'),
            array('newPassword, newPasswordConfirm', 'length', 'max'=>40,'min'=>6, 'on'=>'password'),
			array('updatedate,remark,deleted,status', 'safe'),
		);
	}

	/**
	 * ORM 关联
     * @return array
     */
	public function relations()
    {
		return array(
		);
	}

	/**
	 * Labels
     * @return array
     */
	public function attributeLabels()
    {
		return array(
			'id' => 'ID',
			'username' => '用户名',
			'password' => '密码',
			'createdate' => '创建时间',
			'updatedate' => '最后登录时间',
			'login_ip' => '最后登录IP',
			'remark' => '备注',
            'deleted' => '是否删除',
            'status' => '状态',
		);
	}

    /**
     * 可用行为列表
     * @return array
     */
    public function behaviors()
    {
        return array(
			// 自动填充创建时间
			'CreateAt' => array(
				'class' => 'application.models.behaviors.CreateAtBehavior',
			),
        );
    }

    public function beforeSave()
    {
        if ($this->isNewRecord)
        {
            $this->password = md5($this->password);
        }
        
        return true;
    }

    public function defaultScope()
    {
        return array(
          //  'condition' => 't.deleted = 0'
        );
    }
    
	/**
	 * 登录
	 * @param string $ip 登录IP
	 */
	public function login($ip)
    {
		$this->login_ip = $ip;
		$this->updatedate = date('Y-m-d H:i:s');
		$this->save();
	}

    public function securePassword($password)
    {
        return md5($password);
    }
}