<?php

/**
 * This is the model class for table "ig_medals".
 */
class Medal extends BaseActiveRecord
{
	/**
	 * The followings are the available columns in table 'ig_medals':
	 * @var integer $medalid
	 * @var string $name
	 * @var integer $available
	 * @var string $image
	 * @var string $type
	 */

	/**
	 * Returns the static model of the specified AR class.
	 * @return Medals the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'ig_medals';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('available', 'numerical', 'integerOnly'=>true),
			array('name', 'length', 'max'=>50),
			array('image', 'length', 'max'=>30),
			array('type', 'length', 'max'=>20),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('medalid, name, available, image, type', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}
	
    public function behaviors()
	{
	    return array(
	        'cache' => array(
	        	'class' => 'application.models.behaviors.Medals.CacheBehavior'
	        ),
	    );
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'medalid' => 'Medalid',
			'name' => 'Name',
			'available' => 'Available',
			'image' => 'Image',
			'type' => 'Type',
		);
	}
	
	public function getImageUrl()
	{
	    return Yii::app()->params['imageUrl'] . 'bbs/medals/'.$this->image;
	}
	
	public function getImageFile()
	{
	    return ROOT_PATH . 'images/bbs/medals/'.$this->image;
	}
}