<?php

class Member extends BaseActiveRecord
{
    public $repassword;

    public $oldGid = false;
	/**
	 * Returns the static model of the specified AR class.
	 * @return CActiveRecord the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'ig_members';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		return array(
			array('username','length','min'=>3, 'max'=>20),
			array('password','length','min'=>6, 'max'=>50),
			array('mobile','length','max'=>11),
			array('regip','length','max'=>15),
			array('username, password, mobile, iorange', 'required'),
			array('username,mobile','unique'),
			array('username','application.extensions.validator.UserNameValidator'),
			array('mobile','application.extensions.validator.MobileValidator'),
            array('password', 'compare', 'compareAttribute'=>'repassword', 'on'=>'register'),
            array('uid, username, iorange, mobile, password, ads, size, groupid, groupexpiry, face, gender, regdate, regip, newpm, lastip, lastvisit, lastactivity, oltime, verify, credits, extcredits1, extcredits2, extcredits3, extcredits4, extcredits5, extcredits6, extcredits7, extcredits8', 'safe'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		    'group' => array(self::BELONGS_TO, 'UserGroup', 'groupid'),
		    'fields' => array(self::HAS_ONE, 'MemberData', 'uid'),
		    'ext' => array(self::HAS_ONE, 'MemberExt', 'uid'),
		);
	}
	
	public function beforeValidate()
	{
		if ($this->isNewRecord)
		{
			$string = $this->username . $this->password . time();
			$this->iorange = substr(md5($string),0,30);
            $this->groupid = 10;
            $this->adminid = 0;
            $this->ads = 6;
            $this->regdate = time();
            $this->lastvisit = time();
            $this->lastactivity = time();
            $this->extcredits1 = 10;
            $this->timeoffset = 8;
            $this->verify = 0;
		}
		
		return true;
	}
	
	public function beforeSave()
	{
		parent::beforeSave();
		
		if ($this->isNewRecord)
		{
			$this->password = md5($this->password);
			$this->regip = $_SERVER['REMOTE_ADDR'];
		}

		return true;
	}
	
	public function afterSave()
	{
		if ($this->isNewRecord)
		{
			$memberData = new MemberData();
			$memberData->uid = $this->uid;
			$memberData->save();
		}

        // 特殊组的用户需要做相应操作
        $group = UserGroup::model()->findByPk($this->groupid);
        if ('member' != $group->gptype)
        {
            $field = MemberData::model()->findByPk($this->uid);
            $upArray = array('uid'=> $this->uid, 'groupid' => $this->oldGid, 'extgroup' => $field->extgroup);
            Front::groupOperate($upArray, $this->groupexpiry, $this->groupid);
        }
        Front::updateMemberCache($this->uid);

        return true;
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'uid' => 'UID',
			'username' => '用户名',
			'password' => '密码',
			'mobile' => '手机号',
			'iorange' => 'SID',
		    'credits' => '积分',
		    'posts' => '发帖数',
		    'forumposts' => '书会发帖数',
		    'regdate' => '注册日期'
		);
	}
}