<?php

/**
 * This is the model class for table "ig_memberfields".
 */
class MemberData extends BaseActiveRecord
{
	/**
	 * The followings are the available columns in table 'ig_memberfields':
	 * @var integer $uid
	 * @var integer $todaypost
	 * @var integer $monthpost
	 * @var string $posts
	 * @var integer $digestposts
	 * @var string $oltime
	 * @var string $lastpost
	 * @var integer $lastforumpost
	 * @var string $medals
	 * @var string $sign
	 * @var integer $friends
	 * @var integer $viewcomment
	 * @var string $banpm
	 * @var integer $bookshelf
	 * @var string $bookshelfs
	 */

	/**
	 * Returns the static model of the specified AR class.
	 * @return MemberData the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'ig_memberfields';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('uid', 'required'),
			array('uid, todaypost, monthpost, digestposts, friends, viewcomment, bookshelf', 'numerical', 'integerOnly'=>true),
			array('posts, lastpost', 'length', 'max'=>10),
			array('medals, bookshelfs', 'length', 'max'=>255),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('uid, todaypost, monthpost, posts, digestposts, lastpost, medals, sign, friends, viewcomment, banpm, bookshelf, bookshelfs', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'uid' => 'Uid',
			'todaypost' => 'Todaypost',
			'monthpost' => 'Monthpost',
			'posts' => 'Posts',
			'digestposts' => 'Digestposts',
			'oltime' => 'Oltime',
			'lastpost' => 'Lastpost',
			'lastforumpost' => 'Lastforumpost',
			'medals' => 'Medals',
			'sign' => 'Sign',
			'friends' => 'Friends',
			'viewcomment' => 'Viewcomment',
			'banpm' => 'Banpm',
			'bookshelf' => 'Bookshelf',
			'bookshelfs' => 'Bookshelfs',
		);
	}

    public function afterSave()
    {
        Front::updateMemberCache($this->uid);
    }
}