<?php

/**
 * This is the model class for table "ig_memberext".
 */
class MemberExt extends BaseActiveRecord
{
	/**
	 * The followings are the available columns in table 'ig_memberext':
	 * @var integer $uid
	 * @var integer $noad
	 * @var integer $autoprogress
	 */

	/**
	 * Returns the static model of the specified AR class.
	 * @return MemberExt the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'ig_memberext';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('uid', 'required'),
			array('uid, noad, autoprogress', 'numerical', 'integerOnly'=>true),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('uid, noad, autoprogress', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'uid' => 'Uid',
			'noad' => 'Noad',
			'autoprogress' => 'Autoprogress',
		);
	}
}