<?php

/**
 * This is the model class for table "ig_message".
 */
class Messages extends BaseActiveRecord
{
	/**
	 * The followings are the available columns in table 'ig_message':
	 * @var integer $mid
	 * @var string $msgfrom
	 * @var integer $msgfromid
	 * @var integer $msgtoid
	 * @var integer $did
	 * @var integer $isnew
	 * @var integer $isdelete
	 * @var integer $createdate
	 * @var string $date
	 */

    public static $_isNew = array(0 => '未读', 1 => '已读');

	/**
	 * Returns the static model of the specified AR class.
	 * @return Message the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'ig_message';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('msgfrom, msgfromid, msgtoid, did, date', 'required'),
			array('msgfromid, msgtoid, did, isnew, isdelete, createdate', 'numerical', 'integerOnly'=>true),
			array('msgfrom', 'length', 'max'=>20),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('mid, msgfrom, msgfromid, msgtoid, did, isnew, isdelete, createdate, date', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		    'data' => array(self::BELONGS_TO, 'MessagesData', 'did'),
		    'member' => array(self::BELONGS_TO, 'Member', '', 'on'=>'t.msgtoid=uid'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'mid' => 'MID',
			'msgfrom' => '发送者',
			'msgfromid' => '发送者ID',
			'msgtoid' => '接收者ID',
			'did' => '内容ID',
			'isnew' => 'Isnew',
			'isdelete' => 'Isdelete',
			'createdate' => '创建时间',
			'date' => 'Date',
		);
	}
	
	public function create($subject, $message, $msgto, $isGroup = false)
	{
	    $date = date('Y-m-d');
	    $time = time();
	    $mData = new MessagesData();
	    $mData->subject = $subject;
	    $mData->message = $message;
	    $mData->createdate = $time;
	    if (!$mData->save())
	    {
	        $errors = $mData->getErrors();
	        if (!empty($errors))
	        {
	            foreach ($errors as $error)
	            {
	                $e[] = implode("\n",$error);
	            }
	            $errorString = "\n错误信息\n".implode("\n",$e);
	        }
	        throw new Exception('短信发送失败，请检查发送内容是否符合要求'.$errorString);
	    }

	    $did = $mData->did;
	    if ($isGroup)
	    {
	        $mModel = new Messages();
	        $mModel->did = $did;
	        $mModel->msgtoid = 0;
	        $mModel->msgfrom = 'admin';
	        $mModel->msgfromid = 1;
	        $mModel->date = $date;
	        $mModel->createdate = $time;
	        $mModel->save();
	        
	        Member::model()->updateCounters(array('newpm'=>1));
	    }
	    else
	    {
	        $to = explode(',', $msgto);
	        foreach ($to as $uid)
	        {
	            $mModel = new Messages();
	            $mModel->did = $did;
    	        $mModel->msgtoid = $uid;
    	        $mModel->msgfrom = 'admin';
    	        $mModel->msgfromid = 1;
    	        $mModel->date = $date;
    	        $mModel->createdate = $time;
    	        $mModel->save();
    	        
    	        Member::model()->updateCounters(array('newpm'=>1),'uid='.$uid);
	        }
	    }
	}

    public function getIsNew()
    {
        echo !$this->isnew ? '已读' : '<font color="red">未读</font>';
    }
}