<?php

/**
 * This is the model class for table "ig_messagedata".
 */
class MessagesData extends BaseActiveRecord
{
	/**
	 * The followings are the available columns in table 'ig_messagedata':
	 * @var string $did
	 * @var string $subject
	 * @var string $message
	 * @var integer $createdate
	 */

	/**
	 * Returns the static model of the specified AR class.
	 * @return MessageData the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'ig_messagedata';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('subject, message', 'required'),
			array('createdate', 'numerical', 'integerOnly'=>true),
			array('subject', 'length', 'max'=>200),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('did, subject, message, createdate', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'did' => 'Did',
			'subject' => '标题',
			'message' => '内容',
			'createdate' => '创建时间',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('did',$this->did,true);

		$criteria->compare('subject',$this->subject,true);

		$criteria->compare('message',$this->message,true);

		$criteria->compare('createdate',$this->createdate);

		return new CActiveDataProvider(get_class($this), array(
			'criteria'=>$criteria,
		));
	}
}