<?php

/**
 * This is the model class for table "ig_oreport".
 */
class Oreport extends BaseActiveRecord
{
	/**
	 * The followings are the available columns in table 'ig_oreport':
	 * @var integer $id
	 * @var string $bookname
	 * @var string $chaptername
	 * @var integer $bid
	 * @var integer $cid
	 * @var integer $uid
	 * @var string $username
	 * @var string $createdate
	 * @var string $date
	 * @var integer $aid
	 * @var string $author
	 * @var string $type
	 * @var string $remark
	 * @var string $url
	 * @var integer $status
	 */

	/**
	 * Returns the static model of the specified AR class.
	 * @return Oreport the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'ig_oreport';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('bid, cid, uid, username, createdate, date, author, url', 'required'),
			array('bid, cid, uid, aid, status', 'numerical', 'integerOnly'=>true),
			array('bookname, chaptername', 'length', 'max'=>100),
			array('type', 'length', 'max'=>50),
			array('url', 'length', 'max'=>200),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id, bookname, chaptername, bid, cid, uid, username, createdate, date, aid, author, type, remark, url, status', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'bookname' => '书名',
			'chaptername' => '章节名',
			'bid' => '小说ID',
			'cid' => '章节ID',
			'uid' => 'UID',
			'username' => '举报人',
			'createdate' => '创建时间',
			'aid' => '作者ID',
			'author' => '作者名',
			'type' => '类型',
			'remark' => '备注',
			'url' => '地址',
			'status' => '状态',
		);
	}

	public function viewStatus($status)
    {
        echo !$status ? '<font color="red">未处理</font>' : (1 == $status ? '已处理' : '已取消');
    }
}