<?php

/**
 * This is the model class for table "ig_permission".
 */
class Permission extends BaseActiveRecord
{
	/**
	 * The followings are the available columns in table 'ig_permission':
	 * @var string $uid
	 * @var integer $fid
	 * @var integer $gid
	 * @var string $rkey
	 * @var string $rvalue
	 * @var string $type
	 */

	/**
	 * Returns the static model of the specified AR class.
	 * @return Permission the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'ig_permission';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('uid, fid, gid, rkey', 'required'),
			array('fid, gid', 'numerical', 'integerOnly'=>true),
			array('uid', 'length', 'max'=>10),
			array('rkey', 'length', 'max'=>20),
			array('type', 'length', 'max'=>11),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('uid, fid, gid, rkey, rvalue, type', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'uid' => 'Uid',
			'fid' => 'Fid',
			'gid' => 'Gid',
			'rkey' => 'Rkey',
			'rvalue' => 'Rvalue',
			'type' => 'Type',
		);
	}
}