<?php

/**
 * This is the model class for table "cdb_pms".
 */
class Pm extends BaseActiveRecord
{
	/**
	 * The followings are the available columns in table 'cdb_pms':
	 * @var integer $pmid
	 * @var string $msgfrom
	 * @var integer $msgfromid
	 * @var integer $msgtoid
	 * @var string $folder
	 * @var integer $new
	 * @var string $subject
	 * @var integer $dateline
	 * @var string $message
	 * @var integer $delstatus
	 */

	/**
	 * Returns the static model of the specified AR class.
	 * @return Pm the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'cdb_pms';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('message', 'required'),
			array('msgfromid, msgtoid, new, dateline, delstatus', 'numerical', 'integerOnly'=>true),
			array('msgfrom', 'length', 'max'=>15),
			array('folder', 'length', 'max'=>6),
			array('subject', 'length', 'max'=>75),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('msgfrom, msgfromid, msgtoid, folder, new, subject, dateline, message, delstatus', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

    public function beforeValidate()
    {
        parent::beforeValidate();
        
        if ($this->isNewRecord)
        {
            $this->msgfrom = 'admin';
            $this->msgfromid = 1;
            $this->new = 1;
            $this->dateline = time();

            Member::model()->updateByPk($this->msgtoid, array('newpm'=>1), 'uid='.$this->msgtoid);
        }
        
        return true;
    }

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'pmid' => 'Pmid',
			'msgfrom' => 'Msgfrom',
			'msgfromid' => 'Msgfromid',
			'msgtoid' => 'Msgtoid',
			'folder' => 'Folder',
			'new' => 'New',
			'subject' => 'Subject',
			'dateline' => 'Dateline',
			'message' => 'Message',
			'delstatus' => 'Delstatus',
		);
	}
}