<?php

/**
 * This is the model class for table "pmlink".
 */
class Pmlink extends CActiveRecord
{
	/**
	 * The followings are the available columns in table 'pmlink':
	 * @var integer $id
	 * @var string $url
	 * @var string $createdate
	 * @var string $updatedate
	 * @var integer $click
	 * @var integer $status
	 * @var string $name
	 */

	/**
	 * Returns the static model of the specified AR class.
	 * @return CActiveRecord the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'ig_pmlink';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('url, status, name', 'required'),
			array('click, status', 'numerical', 'integerOnly'=>true),
			array('url', 'length', 'max'=>255),
			array('name', 'length', 'max'=>60),
			array('updatedate,award', 'safe'),
			array('id, url, createdate, updatedate, click, status, name', 'safe', 'on'=>'search'),
		);
	}

    public function beforeValidate()
    {
        if ($this->isNewRecord)
        {
            $this->createdate = date('Y-m-d H:i:s');
        }
        return true;
    }

    public function beforeSave()
    {
        if (!$this->isNewRecord)
        {
            $this->updatedate = date('Y-m-d H:i:s');
        }
        return true;
    }

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'url' => '链接地址',
			'createdate' => '创建时间',
			'updatedate' => '修改时间',
			'click' => '点击数',
			'status' => '状态',
			'name' => '标题',
            'award' => '积分奖励',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);

		$criteria->compare('url',$this->url,true);

		$criteria->compare('createdate',$this->createdate,true);

		$criteria->compare('updatedate',$this->updatedate,true);

		$criteria->compare('click',$this->click);

		$criteria->compare('status',$this->status);

		$criteria->compare('name',$this->name,true);

		return new CActiveDataProvider(get_class($this), array(
			'criteria'=>$criteria,
		));
	}
}