<?php

/**
 * This is the model class for table "Pmlinklog".
 */
class Pmlinklog extends CActiveRecord
{
	/**
	 * The followings are the available columns in table 'Pmlinklog':
	 * @var integer $id
	 * @var integer $uid
	 * @var string $username
	 * @var string $createdate
	 * @var integer $status
	 * @var string $updatedate
	 * @var integer $linkid
	 */

	/**
	 * Returns the static model of the specified AR class.
	 * @return CActiveRecord the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'ig_pmlinklog';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('uid, username, createdate, status, updatedate, linkid', 'required'),
			array('uid, status, linkid', 'numerical', 'integerOnly'=>true),
			array('username', 'length', 'max'=>14),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id, uid, username, createdate, status, updatedate, linkid', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'uid' => 'Uid',
			'username' => 'Username',
			'createdate' => 'Createdate',
			'status' => 'Status',
			'updatedate' => 'Updatedate',
			'linkid' => 'Linkid',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);

		$criteria->compare('uid',$this->uid);

		$criteria->compare('username',$this->username,true);

		$criteria->compare('createdate',$this->createdate,true);

		$criteria->compare('status',$this->status);

		$criteria->compare('updatedate',$this->updatedate,true);

		$criteria->compare('linkid',$this->linkid);

		return new CActiveDataProvider(get_class($this), array(
			'criteria'=>$criteria,
		));
	}
}