<?php

/**
 * This is the model class for table "ig_report".
 */
class Reports extends BaseActiveRecord
{
	/**
	 * The followings are the available columns in table 'ig_report':
	 * @var string $id
	 * @var integer $uid
	 * @var string $username
	 * @var integer $bid
	 * @var integer $cid
	 * @var string $url
	 * @var integer $createdate
	 * @var string $date
	 * @var integer $status
	 * @var string $remark
	 * @var string $type
	 */

    public static $status = array(0=>'未处理',1=>'已修复',2=>'已取消');
	/**
	 * Returns the static model of the specified AR class.
	 * @return Reports the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'ig_report';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('uid, username, bid, cid, url, createdate, date, type', 'required'),
			array('uid, bid, cid, createdate, status', 'numerical', 'integerOnly'=>true),
			array('url, remark', 'length', 'max'=>255),
			array('type', 'length', 'max'=>100),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id, uid, username, bid, cid, url, createdate, date, status, remark, type, isfirst', 'safe'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'uid' => 'UID',
			'username' => '用户名',
			'bid' => '小说ID',
			'cid' => '章节ID',
			'url' => '地址',
			'createdate' => '创建日期',
			'date' => '日期',
			'status' => '状态',
			'remark' => '留言',
			'type' => '错误类型',
            'isfirst' => '首发'
		);
	}

    public function  getIsFirst()
    {
        echo $this->isfirst ? '<font color="red">是</font>' : '否';
    }
}