<?php

/**
 * This is the model class for table "ig_rewardflux".
 */
class RewardFlux extends BaseActiveRecord
{
	/**
	 * The followings are the available columns in table 'ig_rewardflux':
	 * @var integer $id
	 * @var integer $ruid
	 * @var integer $uv
	 * @var integer $pv
	 * @var integer $valid_uv
	 * @var integer $valid_pv
	 * @var integer $u_pv
	 * @var integer $u_uv
	 * @var integer $u_valid_uv
	 * @var integer $u_valid_pv
	 * @var integer $register
	 * @var integer $valid_u
	 * @var string $date
	 */

	/**
	 * Returns the static model of the specified AR class.
	 * @return RewardFlux the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'ig_rewardflux';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('date', 'required'),
			array('ruid, uv, pv, valid_uv, valid_pv, u_pv, u_uv, u_valid_uv, u_valid_pv, register, valid_u, isvalid_entrance', 'numerical', 'integerOnly'=>true),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id, ruid, uv, pv, valid_uv, valid_pv, u_pv, u_uv, u_valid_uv, u_valid_pv, isvalid_entrance, register, valid_u, date', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		    'member' => array(self::BELONGS_TO, 'Member', 'ruid', 'on' => 't.ruid=member.uid'),
		    'ruidremark' => array(self::BELONGS_TO, 'Ruidremark', '', 'on' => 't.ruid=ruidremark.ruid'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'ruid' => 'UID',
			'uv' => 'UV',
			'pv' => 'PV',
			'valid_uv' => '手机UV',
			'valid_pv' => '手机PV',
			'u_pv' => 'UPV',
			'u_uv' => 'UUV',
			'u_valid_uv' => 'U Valid Uv',
			'u_valid_pv' => 'U Valid Pv',
			'register' => '注册用户',
			'valid_u' => '验证用户',
			'date' => '时间',
            'entrance' => '入口数',
            'valid_entrance' => '手机入口',
            'isvalid_entrance' => '有效入口',
            'n_pv' => '新增PV',
            'n_valid_pv' => '新增有效PV'
		);
	}
	
	public static function dataSum(CDbCriteria $criteria)
	{
	    $c = clone $criteria;
	    $c->select = 'SUM(pv) AS pv, SUM(uv) AS uv, SUM(register) AS register, SUM(valid_u) AS valid_u, SUM(valid_pv) AS valid_pv, SUM(valid_uv) AS valid_uv, SUM(u_pv) AS u_pv, SUM(u_uv) AS u_uv, SUM(u_valid_pv) AS u_valid_pv, SUM(u_valid_uv) AS u_valid_uv';
	    $c->with = '';
	    return RewardFlux::model()->find($c);
	}
}