<?php

/**
 * This is the model class for table "ig_rewardsum".
 */
class RewardSum extends BaseActiveRecord
{
	/**
	 * The followings are the available columns in table 'ig_rewardsum':
	 * @var string $date
	 * @var integer $pv
	 * @var integer $uv
	 * @var integer $valid_pv
	 * @var integer $valid_uv
	 * @var integer $u_pv
	 * @var integer $u_uv
	 * @var integer $u_valid_pv
	 * @var integer $u_valid_uv
	 * @var integer $register
	 * @var integer $valid_u
	 */

	/**
	 * Returns the static model of the specified AR class.
	 * @return RewardSum the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'ig_rewardsum';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('date', 'required'),
			array('pv, uv, valid_pv, valid_uv, u_pv, u_uv, u_valid_pv, u_valid_uv, register, valid_u,isvalid_entrance', 'numerical', 'integerOnly'=>true),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('date, pv, uv, valid_pv, valid_uv, u_pv, u_uv, u_valid_pv, u_valid_uv, register, valid_u,isvalid_entrance', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'date' => 'Date',
			'pv' => 'Pv',
			'uv' => 'Uv',
			'valid_pv' => 'Valid Pv',
			'valid_uv' => 'Valid Uv',
			'u_pv' => 'U Pv',
			'u_uv' => 'U Uv',
			'u_valid_pv' => 'U Valid Pv',
			'u_valid_uv' => 'U Valid Uv',
			'register' => 'Register',
			'valid_u' => 'Valid U',
		);
	}
}