<?php

/**
 * This is the model class for table "ig_ruidremark".
 */
class Ruidremark extends BaseActiveRecord
{
	/**
	 * The followings are the available columns in table 'ig_ruidremark':
	 * @var integer $ruid
	 * @var string $name
	 */

	/**
	 * Returns the static model of the specified AR class.
	 * @return Ruidremark the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'ig_ruidremark';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('ruid, name', 'required'),
			array('ruid', 'numerical', 'integerOnly'=>true),
			array('name', 'length', 'max'=>50),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('ruid, name', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'ruid' => 'Ruid',
			'name' => 'Name',
		);
	}
}