<?php

/**
 * This is the model class for table "sale_join".
 */
class SaleJoin extends BaseActiveRecord
{
	/**
	 * The followings are the available columns in table 'sale_join':
	 * @var integer $id
	 * @var integer $uid
	 * @var string $username
	 * @var integer $sale_id
	 * @var string $createdate
	 * @var integer $amount
	 */

    /**
     * 用户金额汇总
     * @var int
     */
    public $userAmount;
    
    /**
     * 用户投注次数
     * @var int
     */
    public $count;
	/**
	 * Returns the static model of the specified AR class.
	 * @return SaleJoin the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'ig_sale_join';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('uid, username, sale_id, createdate, amount', 'required'),
			array('uid, sale_id, amount', 'numerical', 'integerOnly'=>true),
			array('username', 'length', 'max'=>20),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id, uid, username, sale_id, createdate, amount', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'uid' => 'UID',
			'username' => '用户名',
			'sale_id' => '竞拍ID',
			'createdate' => '创建时间',
			'amount' => '金额',
            'count' => '投注次数',
            'userAmount' => '投注总金额'
		);
	}
}