<?php

/**
 * This is the model class for table "ig_settings".
 */
class Settings extends BaseActiveRecord
{
	/**
	 * The followings are the available columns in table 'ig_settings':
	 * @var string $varname
	 * @var string $info
	 * @var string $value
	 */

	/**
	 * Returns the static model of the specified AR class.
	 * @return Settings the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'ig_settings';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('var', 'length', 'max'=>30),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('varname, value', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'varname' => 'Varname',
			'info' => 'Info',
			'value' => 'Value',
		);
	}

	/**
	 * 生成一个配置缓存文件
	 * @param array $array
	 * @return void
	 */
	public function createCache($array)
	{
	    $file = ROOT_PATH . 'cache/Settings.inc.php';
	    file_put_contents($file, "<?php\nreturn ".var_export($array,true).';');
	}
	
	/**
	 * 获取一个数组的结果集
	 * @return array
	 */
	public function getArrayResult()
	{
	    $arrayResult = array();
	    $settings = $this->findAll();
	    foreach ($settings as $setting)
	    {
	        $arrayResult[$setting->var] = $setting->value;
	    }
	    
	    return $arrayResult;
	}
}