<?php

/**
 * This is the model class for table "ig_smiles".
 */
class Smiles extends BaseActiveRecord
{
	/**
	 * The followings are the available columns in table 'ig_smiles':
	 * @var integer $id
	 * @var string $name
	 * @var integer $type
	 * @var string $code
	 * @var string $path
	 * @var integer $displayorder
	 */
    
	/**
	 * Returns the static model of the specified AR class.
	 * @return Smiles the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'ig_smiles';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('type, displayorder', 'numerical', 'integerOnly'=>true),
			array('name', 'length', 'max'=>20),
			array('code, path', 'length', 'max'=>30),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id, name, type, code, path, displayorder', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}
	
    public function behaviors()
	{
	    return array(
	        'cache' => array(
	        	'class' => 'application.models.behaviors.Smiles.CacheBehavior'
	        ),
	    );
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'name' => 'Name',
			'type' => 'Type',
			'code' => 'Code',
			'path' => 'Path',
			'displayorder' => 'Displayorder',
		);
	}
	
	public function getSmileUrl($path)
	{
	    return Yii::app()->params['imageUrl'] . 'bbs/smile/'.$path;
	}
	
	public function getSmilePath($path)
	{
	    return $this->getBasePath() . $path;
	}
	
	public function getBasePath()
	{
	    return ROOT_PATH . 'images/bbs/smile/';
	}
}