<?php

/**
 * This is the model class for table "soft_content".
 */
class SoftContent extends BaseActiveRecord
{
	/**
	 * The followings are the available columns in table 'soft_content':
	 * @var string $id
	 * @var string $name
	 * @var string $short_name
	 * @var integer $cid
	 * @var integer $pid
	 * @var string $createdate
	 * @var string $updatedate
	 * @var string $info
	 * @var integer $day_download
	 * @var integer $week_download
	 * @var integer $month_download
	 * @var integer $download
	 * @var integer $isdelete
	 * @var integer $iscommend
	 * @var string $tips
	 * @var integer $comments
	 */
    public $Filedata;

    /**
     * 软件截图列表
     * @var SoftCpic
     */
    public $cpic = '';
	/**
	 * Returns the static model of the specified AR class.
	 * @return SoftContent the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

    public static function getTypeList()
    {
        return Front::getSoftTypeList();
    }

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'ig_soft_content';
	}

    /**
     * 可用行为列表
     * @return array
     */
    public function behaviors()
    {
        return array(
			// 自动填充创建时间
			'CreateAt' => array(
				'class' => 'application.models.behaviors.CreateAtBehavior',
			),
            'UpdateAt' => array(
				'class' => 'application.models.behaviors.UpdateAtBehavior',
			),
        );
    }

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('createdate, info, name, short_name, cid, pid, type', 'required'),
            array('Filedata', 'file', 'allowEmpty' => true, 'types' => 'jpg,gif', 'maxSize' => '10485760', 'tooLarge' => '文件大小不能超过10M'),
			array('cid, pid, day_download, week_download, month_download, download, isfree, source, isdelete, iscommend, award, comments, images', 'numerical', 'integerOnly'=>true),
			array('name, tips, adurl', 'length', 'max'=>255),
			array('short_name, version', 'length', 'max'=>50),
            array('award_expiry', 'length', 'max'=>11),
			array('id, name, short_name, cid, pid, adurl, version, isfree, award, award_expiry, source, type, createdate, updatedate, date, info, day_download, week_download, month_download, download, isdelete, iscommend, tips, comments, images', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
            'category' => array(self::BELONGS_TO, 'SoftCategory', 'cid'),
            'platform' => array(self::BELONGS_TO, 'SoftPlatform', 'pid'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'name' => '软件名',
			'short_name' => '推广名',
			'cid' => '分类',
			'pid' => '平台',
			'info' => '简介',
			'day_download' => '日下载',
			'week_download' => '周下载',
			'month_download' => '月下载',
			'download' => '总下载',
			'isdelete' => '删除',
			'iscommend' => '推荐',
			'tips' => '提示',
			'comments' => '评论数',
            'adurl' => '下载地址',
            'createdate' => '创建日期',
			'updatedate' => '修改日期',
            'type' => '类型',
            'version' => '版本号',
            'isfree' => '推广',
            'award' => '奖励',
            'award_expiry' => '奖励过期',
            'source' => '来源',
		);
	}

    public function beforeSave()
    {
        if ($this->isNewRecord)
        {
            $this->date = date('Y-m-d');
        }
        $this->info = str_replace(array('&', '&amp;'), array('&amp;', '&'), $this->info);

        return true;
    }

    public function afterFind()
    {
        if ($this->images)
        {
            $this->cpic = SoftCpic::model()->findAll(array('condition'=>'cid='.$this->id));
        }

        return true;
    }

    /**
     * 输出一个推荐标记
     * @return void
     */
    public function isCommend()
    {
        echo $this->iscommend ? '<font color="red">是</font>' : '否';
    }

    public function isFree()
    {
        echo $this->isfree ? '<font color="red">是</font>' : '否';
    }

    public function isAward()
    {
        return $this->award && (!empty($this->award_expiry) && $this->award_expiry >= date('Y-m-d') || empty($this->award_expiry));
    }

    /**
     * 获取软件类型名（游戏 OR 软件）
     * @param  int $id
     * @return string
     */
    public function getTypeName($id)
    {
        $type = self::getTypeList();

        return $type[$id];
    }
}