<?php

/**
 * This is the model class for table "soft_cpic".
 */
class SoftCpic extends BaseActiveRecord
{
	/**
	 * The followings are the available columns in table 'soft_cpic':
	 * @var string $id
	 * @var integer $cid
	 * @var string $name
	 * @var string $createdate
	 * @var string $info
	 */

	/**
	 * Returns the static model of the specified AR class.
	 * @return SofCpic the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'ig_soft_cpic';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('name, createdate, date', 'required'),
			array('cid', 'numerical', 'integerOnly'=>true),
			array('name', 'length', 'max'=>100),
			array('info', 'length', 'max'=>255),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id, cid, name, createdate, info, date', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'cid' => 'Cid',
			'name' => 'Name',
			'createdate' => 'Createdate',
			'info' => 'Info',
		);
	}

    /**
     * 可用行为列表
     * @return array
     */
    public function behaviors()
    {
        return array(
			// 自动填充创建时间
			'CreateAt' => array(
				'class' => 'application.models.behaviors.CreateAtBehavior',
			),
        );
    }

    public function afterDelete()
    {
        $file = $this->getFile();
        if (is_file($file))
        {
            @unlink($file);
        }

        $soft = SoftContent::model()->findByPk($this->cid);
        $soft->images = $this->count(array('condition'=>'cid='.$this->cid));
        $soft->save();
        
        return true;
    }

    public function getFile()
    {
        return $this->getSavePath() . $this->name;
    }

    public function getSavePath()
    {
        return Front::getSoftBaseSavePath($this->date, 'image');
    }
}