<?php

/**
 * This is the model class for table "soft_downloads".
 */
class SoftDownload extends BaseActiveRecord
{
	/**
	 * The followings are the available columns in table 'soft_downloads':
	 * @var string $id
	 * @var integer $cid
	 * @var integer $fid
	 * @var integer $uid
	 * @var string $ua
	 * @var string $createdate
	 * @var string $date
	 */

	/**
	 * Returns the static model of the specified AR class.
	 * @return SoftDownloads the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'ig_soft_downloads';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('createdate, date', 'required'),
			array('cid, fid, uid', 'numerical', 'integerOnly'=>true),
			array('ua', 'length', 'max'=>255),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id, cid, fid, uid, ua, createdate, date', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

    public function beforeValidate()
    {
        if ($this->isNewRecord)
        {
            $this->date = date('Y-m-d');
            $this->createdate = date('Y-m-d H:i:s');
        }

        return true;
    }

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'cid' => 'Cid',
			'fid' => 'Fid',
			'uid' => 'Uid',
			'ua' => 'Ua',
			'createdate' => 'Createdate',
			'date' => 'Date',
		);
	}
}