<?php

/**
 * This is the model class for table "soft_pcontent".
 */
class SoftPcontent extends BaseActiveRecord
{
	/**
	 * The followings are the available columns in table 'soft_pcontent':
	 * @var string $id
	 * @var integer $cid
	 * @var string $name
	 * @var string $info
	 * @var integer $isdelete
	 * @var string $createdate
	 * @var integer $size
	 * @var integer $day_download
	 * @var integer $week_download
	 * @var integer $month_download
	 * @var integer $download
	 * @var string $support
	 */
    /**
     * 文件
     * @var CUploadedFile
     */
    public $Filedata;

	/**
	 * Returns the static model of the specified AR class.
	 * @return SoftPcontent the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'ig_soft_pcontent';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('name, createdate', 'required'),
            array('Filedata', 'file', 'allowEmpty' => true, 'types' => 'jar,sis,sisx,apk,app,deb,ipa,pxl,jpg', 'maxSize' => '10485760', 'tooLarge' => '文件大小不能超过10M'),
			array('cid, pid, isdelete, size, day_download, week_download, month_download, download', 'numerical', 'integerOnly'=>true),
			array('name', 'length', 'max'=>200),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id, cid, pid, name, info, isdelete, createdate, size, day_download, week_download, month_download, download, support', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

    /**
     * 可用行为列表
     * @return array
     */
    public function behaviors()
    {
        return array(
			// 自动填充创建时间
			'CreateAt' => array(
				'class' => 'application.models.behaviors.CreateAtBehavior',
			),
            'UpdateAt' => array(
				'class' => 'application.models.behaviors.UpdateAtBehavior',
			),
        );
    }

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'cid' => 'Cid',
			'name' => 'Name',
			'info' => 'Info',
			'isdelete' => 'Isdelete',
			'createdate' => 'Createdate',
			'size' => 'Size',
			'day_download' => 'Day Download',
			'week_download' => 'Week Download',
			'month_download' => 'Month Download',
			'download' => 'Download',
			'support' => 'Support',
		);
	}
}