<?php

/**
 * This is the model class for table "soft_platform".
 */
class SoftPlatform extends BaseActiveRecord
{
	/**
	 * The followings are the available columns in table 'soft_platform':
	 * @var integer $id
	 * @var string $name
	 * @var string $ename
	 * @var string $info
	 * @var string $company
	 */

	/**
	 * Returns the static model of the specified AR class.
	 * @return SoftPlatform the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'ig_soft_platform';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('info, company', 'required'),
			array('name, ename', 'length', 'max'=>30),
			array('company', 'length', 'max'=>100),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id, name, ename, info, company', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'name' => 'Name',
			'ename' => 'Ename',
			'info' => 'Info',
			'company' => 'Company',
		);
	}
}