<?php

/**
 * This is the model class for table "ig_special".
 */
class Special extends BaseActiveRecord
{
	/**
	 * The followings are the available columns in table 'ig_special':
	 * @var string $id
	 * @var string $subject
	 * @var string $remarks
	 * @var integer $display
	 * @var integer $click
	 * @var string $createdate
	 * @var string $updatedate
	 */

	/**
	 * Returns the static model of the specified AR class.
	 * @return Special the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'ig_special';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('subject, createdate', 'required'),
			array('display, click', 'numerical', 'integerOnly'=>true),
			array('subject', 'length', 'max'=>40),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id, subject, remarks, display, click, createdate, updatedate, deleted, isover', 'safe'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'subject' => '专题名',
			'remarks' => '说明',
			'display' => '显示',
            'isover' => '类型',
			'click' => '点击',
			'createdate' => '创建时间',
			'updatedate' => '更新时间',
		);
	}

    /**
     * 可用行为列表
     * @return array
     */
    public function behaviors()
    {
        return array(
			// 自动填充创建时间
			'CreateAt' => array(
				'class' => 'application.models.behaviors.CreateAtBehavior',
			),
            'UpdateAt' => array(
				'class' => 'application.models.behaviors.UpdateAtBehavior',
			),
        );
    }

    public function isDisplay()
    {
        echo $this->display ? '显示' : '<font color="red">隐藏</font>';
    }

    public function isOver()
    {
        echo $this->isover ? '<font color="red">全本</font>' : '连载';
    }
}