<?php

/**
 * This is the model class for table "ig_specialsubject".
 */
class SpecialSubject extends BaseActiveRecord
{
	/**
	 * The followings are the available columns in table 'ig_specialsubject':
	 * @var integer $id
	 * @var integer $sid
	 * @var integer $bid
	 * @var string $remarks
	 * @var integer $isimg
	 * @var string $createdate
	 * @var string $updatedate
	 */

	/**
	 * Returns the static model of the specified AR class.
	 * @return SpecialSubject the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'ig_specialsubject';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('sid, name, bid, remarks, createdate', 'required'),
			array('sid, bid, isimg', 'numerical', 'integerOnly'=>true),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id, name, sid, bid, remarks, isimg, createdate, updatedate, deleted', 'safe'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
            'book' => array(self::BELONGS_TO, 'Books', 'bid'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'sid' => '专题ID',
            'name' => '推广标题',
			'bid' => '小说ID',
			'remarks' => '说明',
			'isimg' => '显示封面',
			'createdate' => '创建时间',
			'updatedate' => '更新时间',
		);
	}

    /**
     * 可用行为列表
     * @return array
     */
    public function behaviors()
    {
        return array(
			// 自动填充创建时间
			'CreateAt' => array(
				'class' => 'application.models.behaviors.CreateAtBehavior',
			),
            'UpdateAt' => array(
				'class' => 'application.models.behaviors.UpdateAtBehavior',
			),
        );
    }

    public function isImage()
    {
        echo $this->isimg ? '显示' : '不显示';
    }
}