<?php

/**
 * This is the model class for table "ig_task".
 */
class Task extends BaseActiveRecord
{
	/**
	 * The followings are the available columns in table 'ig_task':
	 * @var string $id
	 * @var string $subject
	 * @var string $description
	 * @var string $reward
	 * @var string $createdate
	 */
    public static $statusMap = array(0 => '关闭', 1 => '启用');
    
	/**
	 * Returns the static model of the specified AR class.
	 * @return Task the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'ig_task';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('subject, description, reward, createdate, status', 'required'),
			array('subject, task_url', 'length', 'max'=>255),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id, subject, description, reward, createdate, status, count, factor, task_url', 'safe'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

    /**
     * 可用行为列表
     * @return array
     */
    public function behaviors()
    {
        return array(
			// 自动填充创建时间
			'CreateAt' => array(
				'class' => 'application.models.behaviors.CreateAtBehavior',
			),
            'UpdateAt' => array(
				'class' => 'application.models.behaviors.UpdateAtBehavior',
			),
        );
    }
    
	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'subject' => '任务名',
			'description' => '任务描述',
			'reward' => '奖励',
			'createdate' => '创建时间',
            'status' => '状态',
            'count' => '完成人数',
            'factor' => '完成条件',
            'task_url' => '任务地址',
		);
	}

    public function beforeSave()
    {
        $this->task_url = str_replace(array('&amp;', '&'), array('&', '&amp;'), $this->task_url);

        return true;
    }

    public function getStatusView()
    {
        echo $this->status ? '启用' : '<font color="red">关闭</font>';
    }

    /**
     * 获得用户的任务列表(可参与或进行中的)
     * @param  int $uid
     * @return array
     */
    public function getList($uid)
    {
        $result = array();
        $criteria = new CDbCriteria();
        $criteria->addCondition('status=1');
        $joins = Tasker::model()->findAll(array('condition'=>'uid='.$uid));
        if (!empty($joins))
        {
            $joinList = $doIngList = array();
            foreach ($joins as $join)
            {
                if ($join->status != 1)
                {
                    $joinList[] = $join->task_id;
                }
                else
                {
                    $doIngList[] = $join->task_id;
                }
            }
            if (array() !== $joinList)
            {
                $criteria->addNotInCondition('id', $joinList);
            }
        }

        return array(Task::model()->findAll($criteria), $doIngList);
    }
}