<?php

/**
 * This is the model class for table "ig_taskrespone".
 */
class TaskRespone extends BaseActiveRecord
{
	/**
	 * The followings are the available columns in table 'ig_taskrespone':
	 * @var string $id
	 * @var integer $uid
	 * @var integer $task_id
	 * @var integer $tasker_id
	 * @var string $content
	 */
    public static $statusMap = array(
        0 => '未处理',
        1 => '已奖励',
    );

	/**
	 * Returns the static model of the specified AR class.
	 * @return TaskRespone the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'ig_taskrespone';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('tasker_id, content, createdate', 'required'),
			array('uid, task_id, tasker_id', 'numerical', 'integerOnly'=>true),
			array('content', 'length', 'max'=>255),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id, uid, task_id, tasker_id, content, status, createdate, updatedate', 'safe'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
            'task' => array(self::BELONGS_TO, 'Task', 'task_id'),
		);
	}

    /**
     * 可用行为列表
     * @return array
     */
    public function behaviors()
    {
        return array(
			// 自动填充创建时间
			'CreateAt' => array(
				'class' => 'application.models.behaviors.CreateAtBehavior',
			),
            'UpdateAt' => array(
				'class' => 'application.models.behaviors.UpdateAtBehavior',
			),
        );
    }

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'uid' => 'UID',
            'username' => '用户名',
			'task_id' => '任务ID',
			'tasker_id' => 'Tasker',
			'content' => '返回内容',
            'createdate' => '创建时间',
            'status' => '状态',
		);
	}

    public function getStatus()
    {
        echo $this->status ? self::$statusMap[$this->status] : '<font color="red">'.self::$statusMap[$this->status].'</font>';
    }
}