<?php

/**
 * This is the model class for table "ig_tasker".
 */
class Tasker extends BaseActiveRecord
{
	/**
	 * The followings are the available columns in table 'ig_tasker':
	 * @var string $id
	 * @var integer $task_id
	 * @var integer $uid
	 * @var integer $status
	 * @var string $createdate
	 * @var string $done
	 */
    public static $statusMap = array(
        0 => '失败',
        1 => '进行中',
        2 => '审核中',
        3 => '完成',
    );
    
	/**
	 * Returns the static model of the specified AR class.
	 * @return Tasker the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'ig_tasker';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('createdate', 'required'),
			array('task_id, uid, status', 'numerical', 'integerOnly'=>true),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id, task_id, uid, status, createdate, updatedate', 'safe'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
            'task' => array(self::BELONGS_TO, 'Task', 'task_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'task_id' => '任务ID',
			'uid' => 'UID',
            'username' => '用户名',
			'status' => '状态',
			'createdate' => '创建时间',
			'updatedate' => '修改时间',
		);
	}

    public function getStatus()
    {
        echo self::$statusMap[$this->status];
    }
}