<?php

/**
 * This is the model class for table "ig_topictype".
 */
class TopicTypes extends BaseActiveRecord
{
	/**
	 * The followings are the available columns in table 'ig_topictype':
	 * @var integer $id
	 * @var integer $fid
	 * @var string $name
	 * @var integer $vieworder
	 */

	/**
	 * Returns the static model of the specified AR class.
	 * @return TopicTypes the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'ig_topictype';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('fid', 'required'),
			array('fid, vieworder', 'numerical', 'integerOnly'=>true),
			array('name', 'length', 'max'=>200),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id, fid, name, vieworder', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	public function behaviors()
	{
	    return array(
	        'cache' => array(
	            'class' => 'application.models.behaviors.TopicTypes.CaBehavior'
	        )
	    );
	}
	
	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'fid' => 'Fid',
			'name' => 'Name',
			'vieworder' => 'Vieworder',
		);
	}
}