<?php

class Type extends BaseActiveRecord
{
	/**
	 * The followings are the available columns in table 'type':
	 * @var integer $typeid
	 * @var string $typename
	 * @var string $type
	 * @var integer $sort
	 */

	/**
	 * Returns the static model of the specified AR class.
	 * @return CActiveRecord the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'ig_type';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		return array(
			array('typename','length','max'=>30),
			array('type','length','max'=>10),
			array('typename, type', 'required'),
			array('sort', 'numerical', 'integerOnly'=>true),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'book' => array(self::HAS_MANY, 'Books', 'typeid', 'alias'=>'book'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'typeid' => 'ID',
			'typename' => '分类名',
			'type' => '所属模块',
			'sort' => '排序',
		);
	}
}