<?php

/**
 * This is the model class for table "ig_usergroups".
 */
class UserGroup extends BaseActiveRecord
{
	/**
	 * The followings are the available columns in table 'ig_usergroups':
	 * @var integer $gid
	 * @var string $gptype
	 * @var string $grouptitle
	 * @var string $groupimg
	 * @var integer $grouppost
	 * @var integer $ifdefault
	 */

	/**
	 * Returns the static model of the specified AR class.
	 * @return UserGroups the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'ig_usergroups';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('isdefault', 'numerical', 'integerOnly'=>true),
			array('gptype', 'length', 'max'=>7),
			array('grouptitle', 'length', 'max'=>60),
			array('groupimg', 'length', 'max'=>15),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('groupid, gptype, grouptitle, grouptitle1, grouptitle2, groupimg, isdefault', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'groupid' => 'Gid',
			'gptype' => 'Gptype',
			'grouptitle' => 'Grouptitle',
			'groupimg' => 'Groupimg',
			'grouppost' => 'Grouppost',
			'ifdefault' => 'Ifdefault',
		);
	}
	
    public function behaviors()
	{
	    return array(
	        'cache' => array(
	        	'class' => 'application.models.behaviors.UserGroups.CacheBehavior'
	        ),
	    );
	}
	
	public static function saveGroupCache($groupId, $data)
	{
	    $file = ROOT_PATH . 'cache/bbs/usergroup/group_'.$groupId.'.php';
	    file_put_contents($file, "<?php\nreturn ".var_export($data,true).';');
	}
	
	public static function deleteGroupCache($groupId)
	{
	    $file = ROOT_PATH . 'cache/bbs/usergroup/group_'.$groupId.'.php';
	    if (is_file($file) && is_writable($file))
	    {
	        @unlink($file);
	    }
	}
	
	/**
	 * 从缓存文件里获取等级信息
	 * @param int $groupId
	 * @return array
	 */
	public static function getGroupCache($groupId = 0)
	{
	    $file = ROOT_PATH . 'cache/bbs/usergroup/group_'.$groupId.'.php';
	    if (is_file($file))
	    {
	        return require $file;
	    }
	    return array();
	}
	
	/**
	 * 获取等级图片
	 * @return string
	 */
	public function getImageUrl()
	{
	    return Yii::app()->baseUrl . '/images/level/'.$this->groupimg . '.gif';
	}
}