<?php
class CacheBehavior extends CActiveRecordBehavior
{
    public function afterSave($event)
    {
        $array = array();
        foreach ($this->getOwner()->attributes as $key => $value)
        {
	        if ('forumset' == $key)
	        {
	            $array[$key] = unserialize($value);
	        }
	        else
	        {
	            $array[$key] = $value;
	        }
        }
        $this->getOwner()->createCache($array);
        
        $this->forumListCache();
        return true;
    }
    
    public function afterDelete($event)
    {
        $file = $this->Owner->getCacheFile();
	    if (is_file($file))
	    {
	        @unlink($file);
	    }
	    
	    $this->forumListCache();
	    return true;
    }
    
    private function forumListCache()
    {
        $forumsFile = ROOT_PATH . 'cache/bbs/forums/forums.php';
        $forumsList = ROOT_PATH . 'cache/bbs/forums/forums_list.php';
        
        $catedb = $forumdb = $subdb1 = $subdb2 = $forum_cache = $fname= array();
        $fkeys = array('fid' , 'fup' , 'ifsub' , 'childid' , 'type' , 'name' , 'forumadmin', 'description' , 'keywords', 'allowvisit');
        $forums = $this->Owner->findAll(array('order'=>'vieworder DESC,fid DESC'));
        foreach ($forums as $value)
        {
            foreach ($fkeys as $k)
            {
                $forum[$k] = $value->$k;
            }
            if ('category' == $forum['type'])
            {
                $catedb[] = $forum;
            }
            elseif ('forum' == $forum['type'])
            {
                $forumdb[$forum['fup']] || $forumdb[$forum['fup']] = array();
                $forumdb[$forum['fup']][] = $forum;
            }
            elseif ($forum['type'] == 'sub')
            {
                $subdb1[$forum['fup']] || $subdb1[$forum['fup']] = array();
                $subdb1[$forum['fup']][] = $forum;
            }
            else
            {
                $subdb2[$forum['fup']] || $subdb2[$forum['fup']] = array();
                $subdb2[$forum['fup']][] = $forum;
            }
        }
        
        $forumAllList = $forumlist_cache = array();
        foreach ($catedb as $cate)
        {
            if (!$cate)
            {
                continue;
            }
            $forum_cache[$cate['fid']] = $cate;
            
            if ($forumdb[$cate['fid']])
            {
                $forumlist_cache[$cate['fid']]['name'] = strip_tags($cate['name']);
            }
            
            if (!$forumdb[$cate['fid']])
            {
                continue;
            }
            
            foreach ($forumdb[$cate['fid']] as $forum)
            {
                $forum_cache[$forum['fid']] = $forum;
                if (!isset($forumlist_cache[$cate['fid']]['name']))
                {
                    $forumlist_cache[$cate['fid']]['name'] = $forumAllList[$cate['fid']]['name'];
                }
                $forumlist_cache[$cate['fid']]['child'][$forum['fid']] = strip_tags($forum['name']);
                
                if (!$subdb1[$forum['fid']])
                {
                    continue;
                }
                
                foreach ($subdb1[$forum['fid']] as $sub1)
                {
                    $forum_cache[$sub1['fid']] = $sub1;
                    if (!$subdb2[$sub1['fid']])
                    {
                        continue;
                    }
                    foreach ($subdb2[$sub1['fid']] as $sub2)
                    {
                        $forum_cache[$sub2['fid']] = $sub2;
                    }
                }
            }
        }
        
        file_put_contents($forumsFile, "<?php\nreturn ".var_export($forum_cache,true).';');
        file_put_contents($forumsList, "<?php\nreturn ".var_export($forumlist_cache,true).';');
    }
}