<?php
class CacheBehavior extends CActiveRecordBehavior
{
    public function afterDelete($event)
    {
        $this->_cache();
        
        return true;
    }
    
    public function afterSave($event)
    {
        $this->_cache();
        
        return true;
    }
    
    private function _cache()
    {
        $file = ROOT_PATH . 'cache/bbs/medals.php';
        $array = array();
        $medals = Medal::model()->findAll(array('condition'=>'available = 1'));
        foreach ($medals as $medal)
        {
            $array[$medal->medalid]['name'] = $medal->name;
            $array[$medal->medalid]['image'] = $medal->image;
            $array[$medal->medalid]['type'] = $medal->type;
        }
        file_put_contents($file, "<?php\nreturn ".var_export($array,true).';');
    }
}